package gov.va.med.mhv.journal.ws.rest;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.journal.dto.ActivityDetailDTO;
import gov.va.med.mhv.journal.dto.ActivityJournalDTO;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.MealItemDTO;
import gov.va.med.mhv.journal.service.ActivityJournalService;
import gov.va.med.mhv.journal.service.FoodJournalService;
import gov.va.med.mhv.journal.service.JournalWebService;

public class JournalWebServiceImpl implements JournalWebService {
	private static Logger log = LogManager.getLogger(JournalWebServiceImpl.class);

	@Autowired
	private FoodJournalService foodJournalService;

	@Autowired
	private ActivityJournalService activityJournalService;

	@Override
	public List<FoodJournalDTO> getFoodJournalsForUser(Long userProfileId) throws MHVException {
		log.debug("getFoodJournalsForUser, userProfileId=" + userProfileId);

		List<FoodJournalDTO> list = foodJournalService.findFoodJournalsForUser(userProfileId);

		return list;
	}

	@Override
	public List<FoodJournalDTO> getFoodJournalsForDashBoard(Long userProfileId) throws MHVException {
		log.debug("getFoodJournalsForDashBoard, userProfileId=" + userProfileId);

		List<FoodJournalDTO> list = foodJournalService.getFoodJournalsForDashBoard(userProfileId);

		return list;
	}

	@Override
	public FoodJournalDTO getFoodJournalById(Long foodJournalId) throws MHVException {
		log.debug("getFoodJournalById, foodJournalId=" + foodJournalId);

		FoodJournalDTO dto = foodJournalService.findFoodJournalById(foodJournalId);

		return dto;
	}

	@Override
	public List<ActivityJournalDTO> findActivityJournalsForUser(Long userProfileId) throws MHVException {
		log.debug("findActivityJournalsForUser, userProfileId=" + userProfileId);

		List<ActivityJournalDTO> list = activityJournalService.findActivityJournalsForUser(userProfileId);

		return list;
	}

	@Override
	public ActivityJournalDTO findActivityJournalById(Long activityJournalId) throws MHVException {
		log.debug("findActivityJournalById, activityJournalId=" + activityJournalId);

		ActivityJournalDTO dto = activityJournalService.findActivityJournalById(activityJournalId);

		return dto;
	}

	@Override
	public List<ActivityJournalDTO> getActivityJournalsForDashBoard(Long userProfileId) throws MHVException {
		log.debug("getActivityJournalsForDashBoard, userProfileId=" + userProfileId);

		List<ActivityJournalDTO> list = activityJournalService.getActivityJournalsForDashBoard(userProfileId);

		return list;
	}

	@Override
	public FoodJournalDTO addFoodJournal(FoodJournalDTO foodJournalDTO) throws MHVException {
		log.debug("addFoodJournal");

		FoodJournalDTO dto = foodJournalService.addFoodJournal(foodJournalDTO);

		return dto;
	}

	@Override
	public ActivityJournalDTO addActivityJournal(ActivityJournalDTO activityJournalDTO) throws MHVException {
		log.debug("addActivityJournal");

		ActivityJournalDTO dto = activityJournalService.addActivityJournal(activityJournalDTO);

		return dto;
	}

	@Override
	public void deleteFoodJournalById(Long foodJournalId) throws MHVException {
		log.debug("deleteFoodJournalById, foodJournalId=" + foodJournalId);

		foodJournalService.deleteFoodJournal(foodJournalId);
	}

	@Override
	public MealItemDTO addMealItem(MealItemDTO mealItemDTO) throws MHVException {
		log.debug("addMealItem");

		MealItemDTO dto = foodJournalService.addMealItem(mealItemDTO);
		
		return dto;
	}

	@Override
	public ActivityDetailDTO addActivityDetails(ActivityDetailDTO activityDetailDTO) throws MHVException {
		log.debug("addActivityDetails");

		ActivityDetailDTO dto = activityJournalService.addActivityDetails(activityDetailDTO);
		
		return dto;
	}

	@Override
	public void deleteMealItemById(Long mealItemId) throws MHVException {
		log.debug("deleteMealItemById, mealItemId=" + mealItemId);

		foodJournalService.deleteMealItem(mealItemId);
	}

	@Override
	public MealItemDTO getMealItemById(Long mealItemId) throws MHVException {
		log.debug("getMealItemById, mealItemId=" + mealItemId);

		MealItemDTO dto = foodJournalService.getMealItemById(mealItemId);
		
		return dto;
	}

	@Override
	public ActivityDetailDTO getActivityDetailById(Long activityDetailId) throws MHVException {
		log.debug("getActivityDetailById, activityDetailId=" + activityDetailId);

		ActivityDetailDTO dto = activityJournalService.getActivityDetailById(activityDetailId);
		
		return dto;
	}

	@Override
	public void deleteActivityJournalById(Long activityJournalId) throws MHVException {
		log.debug("deleteActivityJournalById, activityJournalId=" + activityJournalId);

		activityJournalService.deleteActivityJournal(activityJournalId);
	}

	@Override
	public void deleteActivityDetailById(Long activityDetailId) throws MHVException {		
		log.debug("deleteActivityDetailById, activityDetailId=" + activityDetailId);

		activityJournalService.deleteActivityDetail(activityDetailId);

	}
}
